/*************************************************/
/* Examples Program For "ET-dsPIC33WEB-V1" Board */
/* Hardware    : ET-dsPIC33WEB-V1.0              */
/* Target MCU  : dsPIC33FJ128GP708               */
/*       	   : X-TAL : 8.00 MHz                */
/* Config Fosc : XTAL = 8MHz (XT+PLL)            */
/*             : PLLPRE[4..0] = 00000 (N1=2)     */
/*             : VCO Input = 8MHz / 2 = 4MHz     */
/*             : PLLDIV[8..0] = 0x26(M=40)       */
/*             : VCO Output = 4 x 40MHz = 160MHz */
/*             : PLLPOST[1:0] = 0:0 (N2=2)       */
/*             : Fosc = 160MHz / 2 = 80MHz       */
/*             : Fcy = Fosc/2 = 80MHz /2 = 40MHz */
/* Compiler    : MPLAB + C30 V3.01  		     */
/* Write By    : Eakachai Makarn(ETT CO.,LTD.)   */
/* Last Update : 16/August/2007                  */
/* Function    : Example Use Timer1 16 Bit Mode  */
/*             : Used Timer Generate Square 1KHz */
/*************************************************/
/* Used Timer1 Control RB0 Generate Square 1 KHz */
/*************************************************/
// ET-dsPIC33WEB-V1 Hardware Board
// Fcy = 40MHz
// Tcy = 1 / 40MHz = 25nS
// Desire Frequency = 1 KHz (1.0 mS Period)
// Desire Timer Prescale = 1
// Timer Clock = 40 MHz  
// 1 Cycle = 25nS
// 1 KHz Cycle Count = 1mS / 25nS
//                   = 40000 Cycle
// Desire 1 KHz Square Wave (50% Duty Cycle)
// Define Timer1 Match = 0.5mS 
//                     = 20000 Cycle

#include "p33FJ128GP708.h"                             				// dsPIC33FJ128GP708 MPU Register

/* Setup Configuration For ET-dsPIC33WEB-V1 */
_FOSCSEL(FNOSC_PRIPLL & 											// Select Primary OSC = XT + PLL
         IESO_OFF )													// Startup With User Select OSC
_FOSC(FCKSM_CSDCMD &        										// Clock Switch Disabled	
      OSCIOFNC_OFF &												// OSC2 Pin = Clock O/P
      POSCMD_XT)													// Primary OSC = XT 
_FWDT(FWDTEN_OFF &           										// Disable Watchdog Timer 
      WINDIS_OFF &          										// Disabled Windowed WDT
      WDTPRE_PR128 &        										// Watchdog prescaler=1:128
      WDTPOST_PS32768)     											// Watchdog postscaler=1:32,768
_FPOR(FPWRT_PWR128)       											// Power-on Reset Value = 128ms
_CONFIG3(JTAGEN_OFF);												// Disable JTAG Interface
/* End of Configuration For ET-dsPIC33WEB-V1 */

/****************************/
/* Timer1 Interrupt Service */
/****************************/
void _ISR _T1Interrupt(void)
{
  TMR1 = 0;          												// Reset Timer to 0x0000 
  LATBbits.LATB0 = !LATBbits.LATB0; 								// Toggle RB0 on Timer1 Match
  IFS0bits.T1IF = 0;												// Reset Timer1 Interrupt Flag
}

int main(void)
{  
  /* Start of PLL Config Fcy = 40MIPS */
  CLKDIV &= 0xFFE0;													// PLLPRE[4..0] = 00000 (N1=2)
  CLKDIV &= 0xFF3F;													// PLLPOST[1:0] = 00 (N2=2)
  PLLFBD  = 0x26;													// PLLDIV[8..0] = 000100110(M=40)
  while(!OSCCONbits.LOCK);											// Wait PLL to Lock
  OSCCONbits.CLKLOCK = 1;											// Disable PLL Modify
  /* End of PLL Config Fly = 40MIPS */

  /* Start of Config Timer1 */
  T1CONbits.TON = 1;    											// ON Timer
  T1CONbits.TSIDL = 1;												// Disable Timer in IDLE Mode
  T1CONbits.TGATE = 0;												// Disable Timer Gate Control
  T1CONbits.TCKPS1 = 0;        										// Timer Prescale = 1:1			
  T1CONbits.TCKPS0 = 0;
  T1CONbits.TCS = 0;												// Timer Clock Source = Internal

  // Setup Timer Start Count
  TMR1 = 0;          												// Reset Timer to 0x0000 
  PR1  = 20000;														// 0.5 Second Period

  // Timer1 Interrupt Control 
  IEC0bits.T1IE = 1;												// Enable Timer1 Interrupt
  IPC0bits.T1IP = 7;												// Timer1 Priority = 7
  /* End of Config Timer1 */

  // Demo Timer1 Control PB0 Generate Squarewave 1KHz //
  TRISBbits.TRISB0 = 0;												// Config RB0 = Output
  while(1);															// Loop Continue
}	  


